/* jshint unused: true */
/* global cx, sc, parameters */

let property = require('common/property');
let aguila = require('common/aguila');

// let metadb = require('common/metadb');
// const settingsPath = 'MAIN_MODULE_MANAGEMENT/customers/cdev.console/Config/aguilaConsole';
// let default_require = JSON.parse(metadb.read(settingsPath)[0]).default_require || ['/* global cx, sc, sca */', "let $$ = require('cdev/ncore');", ''].join('\n');

let dcw = require('/agorum/roi/customers/cdev.console/js/widget-helper');
let settings = require('/agorum/roi/customers/cdev.console/js/aguila/console-settings');
let cs = settings.load();

// let external = parameters.external;

let object,
  title = '';
let default_require =
  cs.default_require ||
  [
    '/* global cx, sc, sca */',
    "let $$ = require('/agorum/roi/customers/cdev.console/js/debug');",
    '$$.environment.debug = true;',
    '',
  ].join('\n');

// load script from file if provided by parameters
if (parameters.script) {
  let objects = require('common/objects');
  let fileObj = objects.tryFind(parameters.script);
  if (fileObj) {
    default_require = fileObj.contentString;
  }
}

delete parameters.id;

let buttons = [
  {
    name: 'runBtn',
    type: 'agorum.button',
    text: 'Run script',
    // icon: 'aguila-icon-yes'
  },
  {
    name: 'channelBtn',
    type: 'agorum.button',
    text: 'Launch channel',
    // icon: 'aguila-icon-yes'
  },
  {
    name: 'initializeBtn',
    type: 'agorum.button',
    text: 'Initialize',
    // icon: 'aguila-icon-arrow-refresh'
  },
  {
    name: 'settingsBtn',
    type: 'agorum.button',
    text: 'Settings',
    // icon: 'aguila-icon-yes'
  },
];

let editor = aguila.create({
  type: 'agorum.border',
  width: 1000,
  height: 700,
  /*
  properties: [
     'hideTitle'
  ],
  */
  docked: {
    top: {
      type: 'agorum.toolbar',
      items: buttons,
    },
    center: {
      name: 'script',
      type: 'agorum.codeEditor',
      language: 'javascript',
      text: '',
    },
    south: {
      name: 'outputContainer',
      type: 'agorum.single',
      height: 100,
      items: [
        {
          type: 'agorum.textArea',
          monospace: true,
        },
      ],
    },
  },
});

let script = editor.down('script');
let outputContainer = editor.down('outputContainer');

// --- output handling
let isJson = false;

function out(value) {
  let needJson = false;

  if (typeof value === 'object') {
    try {
      value = property.from(value).toPrettyString();

      // NOTE: the codeEditor JSON view does not like stringified numbers or strings
      needJson = value[0] === '{' || value[0] === '[';
      // eslint-disable-next-line no-empty
    } catch (err) { }
  }

  if (isJson !== needJson) {
    if (needJson) {
      outputContainer.items = [
        {
          type: 'agorum.codeEditor',
          language: 'json',
        },
      ];
    } else {
      outputContainer.items = [
        {
          type: 'agorum.textArea',
          monospace: true,
        },
      ];
    }

    isJson = needJson;
  }

  outputContainer.items[0].text = value;
}

// --- event handlers
function handle(callback) {
  try {
    callback();

    return true;
  } catch (err) {
    if (err && err.javaException) {
      let sw = new global.java.io.StringWriter();

      err.javaException.printStackTrace(new global.java.io.PrintWriter(sw));

      out(sw.toString());
    } else if (err && err.message) {
      out(err.message + '\n' + err.stack);
    } else {
      out('' + err);
    }
  }
}

function evaluate() {
  let ec = new global.Packages.agorum.roi.scripting.EngineContext(false, sc);

  try {
    ec.put('sc', sc);
    ec.put('sca', sc);
    ec.put('cx', cx);
    ec.put('parameters', {});

    return object ? ec.exec(object) : ec.eval(script.text);
  } finally {
    ec.release();
  }
}

function open(widget) {
  out('');
  handle(() => aguila.openWindow(widget, title + ' (Test)'));
}

function run() {
  let result;

  // TODO: run asynchronously if not an aguila widget (detect "require('common/aguila')"?)
  if (!handle(() => (result = evaluate()))) {
    return;
  }

  if (result && result.widget) {
    // wrapped widget
    open(result.widget);
  } else if (typeof result === 'string') {
    // plain string
    out(result);
  } else {
    // try to interpret as AON
    try {
      // NOTE: explicitly calling aguila.create() to test for valid AON
      open(aguila.create(result));

      return;
      // eslint-disable-next-line no-empty
    } catch (err) { }

    // if all else fails, show as prettified JSON
    out(result);
  }
}

editor.down('runBtn').on('clicked', run);
editor.down('initializeBtn').on('clicked', () => handle(global.Packages.agorum.aguila.main.Initialize.aguila));
editor.down('channelBtn').on('clicked', () => {
  require('filingassistant/service').action('cdev.console.asa.homeactions.aguilaLogChannel');
});
editor.down('settingsBtn').on('clicked', () => {
  let sw = dcw.create(settings.aon);
  settings.init(sw, cs);
  sw.widget.popup({ title: 'Settings', modal: true });
  sw.widget.on('destroying', () => {
    settings.update(sw, cs);
  });
});

// -- load initial value
aguila
  .fork(() => {
    // title = 'aguila console';
    // return "let aguila = require('common/aguila');\n\n";
    return default_require;
  })
  .then(text => {
    if (!parameters.external) editor.form.title = 'aguila console';
    script.text = text;

    script.on('valueChanged', () => {
      if (!object) {
        return;
      }
    });
    parameters.script && run();
  });

if (parameters.external)
  setImmediate(() => {
    editor.form.title = 'aguila console';
  });

aguila.setImmediate(() => {
  // editor.down('script').focus();
});

editor;
